// SetOSDPicture.cpp : implementation file
//

#include "stdafx.h"
#include "MyOSDProperty.h"
#include "SetOSDPicture.h"
#include "afxdialogex.h"


// CSetOSDPicture dialog

IMPLEMENT_DYNAMIC(CSetOSDPicture, CDialogEx)

CSetOSDPicture::CSetOSDPicture(CWnd* pParent /*=NULL*/)
	: CDialogEx(CSetOSDPicture::IDD, pParent)
	, m_nPicTransparent(255)
{
	m_pOSDAlphaBlender = NULL;

	m_nOSDLayer = 1;
	
	m_nXOffset = 5;

	m_nYOffset = 5;

	m_nPicWidth = 320;

	m_nPicHeight = 240;
}

CSetOSDPicture::~CSetOSDPicture()
{
}

void CSetOSDPicture::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT_TEXT_X_OFFSET, m_nXOffset);
	DDV_MinMaxInt(pDX, m_nXOffset, 0, 1920);
	DDX_Text(pDX, IDC_EDIT_TEXT_Y_OFFSET, m_nYOffset);
	DDV_MinMaxInt(pDX, m_nYOffset, 0, 1080);
	DDX_Text(pDX, IDC_EDIT_TEXT_WIDTH, m_nPicWidth);
	DDV_MinMaxInt(pDX, m_nPicWidth, 0, 1920);
	DDX_Text(pDX, IDC_EDIT_TEXT_HEIGHT, m_nPicHeight);
	DDV_MinMaxInt(pDX, m_nPicHeight, 0, 1080);
	DDX_Control(pDX, IDC_COMBO_PIC_OSD_LAYER, m_comboPicOSDLayer);
	DDX_Control(pDX, IDC_STATIC_LOAD_IMAGE, m_scImagePreview);
	DDX_Text(pDX, IDC_EDIT_PIC_TRANSPARENT, m_nPicTransparent);
	DDV_MinMaxInt(pDX, m_nPicTransparent, 0, 255);
	DDX_Control(pDX, IDC_SC_IMAGE_RES, m_scImageRes);
	DDX_Control(pDX, IDC_EDIT_PIC_PATH, m_editPicturePath);
}


BEGIN_MESSAGE_MAP(CSetOSDPicture, CDialogEx)
	ON_WM_DESTROY()
	ON_WM_DRAWITEM()
	ON_BN_CLICKED(IDOK, &CSetOSDPicture::OnBnClickedOk)
	ON_BN_CLICKED(IDCANCEL, &CSetOSDPicture::OnBnClickedCancel)
	ON_BN_CLICKED(ID_BROWSER_PIC_PATH, &CSetOSDPicture::OnBnClickedBrowserPicPath)
	ON_BN_CLICKED(ID_BROWSER_PIC_MOVE, &CSetOSDPicture::OnBnClickedBrowserPicMove)
END_MESSAGE_MAP()


// CSetOSDPicture message handlers

BOOL CSetOSDPicture::OnInitDialog()
{
	CDialogEx::OnInitDialog();	

	// TODO: Add extra initialization here

	m_comboPicOSDLayer.ResetContent();	

	CString str;

	int i = 0;

	for ( i = 0 ; i < 16 ; i++ )
	{
		str.Format(_T("%d"),  i );

		m_comboPicOSDLayer.AddString( str );
	}

	m_comboPicOSDLayer.SetCurSel( 1 );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSetOSDPicture::OnDestroy()
{
	m_scImagePreview.FreeData();

	CDialogEx::OnDestroy();
}

void CSetOSDPicture::OnBnClickedOk()
{
	// TODO: Add your control notification handler code here

	UpdateData( TRUE );

	int nIndex = m_comboPicOSDLayer.GetCurSel();	

	m_nOSDLayer = nIndex;

	BOOL  bSetOSDText = FALSE;

	if ( m_pOSDAlphaBlender != NULL && !m_strLoadImage.IsEmpty() )
	{
		bSetOSDText = AMESDK_OSD_SET_PICTURE(  m_pOSDAlphaBlender, 
			
																						m_nOSDLayer, 
																				
																						m_nXOffset, 
																				
																						m_nYOffset, 
																				
																						m_nPicWidth, 
																				
																						m_nPicHeight, 
																				
																						m_strLoadImage.GetBuffer( 256 ), 
																				
																						m_nPicTransparent );

		m_strLoadImage.ReleaseBuffer();		
	}

	//CDialogEx::OnOK();
}


void CSetOSDPicture::OnBnClickedCancel()
{
	// TODO: Add your control notification handler code here

	CDialogEx::OnCancel();
}


void CSetOSDPicture::OnBnClickedBrowserPicPath()
{
	// TODO: Add your control notification handler code here

	CString			csOpenFileName;

	TCHAR			szCpation[] = _T("Select an image file");

	TCHAR	strFileBuf[0x2000];

	::memset(strFileBuf, 0, sizeof(TCHAR) * 0x19F0);

	CFileDialog	fileDialog(TRUE, 
						   _T("bmp"), 
						   NULL, 
						   NULL, 
						   _T("Image Files (*.bmp;*.gif;*.png;*.tif;*.jpg)|*.bmp; *.gif; *.png; *.tif; *.jpg|All Files (*.*)|*.*||")
						   );

	fileDialog.m_ofn.lpstrTitle = szCpation;

	fileDialog.m_ofn.lpstrInitialDir = m_strBrowseFilePath;	

	fileDialog.m_ofn.lpstrFile = strFileBuf;
	
	if (IDOK == fileDialog.DoModal())	
	{
		CString strCurPath = fileDialog.GetPathName();

		if (strCurPath.Find('.') != -1)
			strCurPath = strCurPath.Left(strCurPath.ReverseFind('\\') + 1);

		m_strBrowseFilePath = strCurPath;

		m_strLoadImage = fileDialog.GetPathName();

		m_editPicturePath.SetWindowText( m_strLoadImage );
	
		m_scImagePreview.Load( m_strLoadImage );	

		UINT dwWidth = 0;

		UINT dwHeight = 0;

		m_scImagePreview.GetImageDimInfo (dwWidth, dwHeight );

		CString strImageSize;

		strImageSize.Format("%d x %d", dwWidth, dwHeight);

		m_scImageRes.SetWindowText( strImageSize );

		m_scImagePreview.Invalidate();
	}
}

void CSetOSDPicture::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	// TODO: Add your message handler code here and/or call default
	
	m_scImagePreview.DrawItem( lpDrawItemStruct ); 

	CDialogEx::OnDrawItem(nIDCtl, lpDrawItemStruct);
}


void CSetOSDPicture::OnBnClickedBrowserPicMove()
{
	// TODO: Add your control notification handler code here

	if ( m_pOSDAlphaBlender != NULL )
	{
		AMESDK_OSD_MOVE_OBJ( m_pOSDAlphaBlender, m_nOSDLayer, 200, 200 );
	}
}
